'use client';
import {useEffect, useRef, useState} from "react";
import {formatDate, getToken, getUserData, SOCKETURL} from "../../../utils/front";
import axios from "axios";
import { io } from "socket.io-client";
import ChatForm from "../../../components/communication/ChatForm";
import styles from "../../../components/communication/LiveChat.module.css";
import bblStyles from "../../../components/communication/Bubble.module.css";
import Bubble from "../../../components/communication/Bubble";
import DeleteMsgPop from "../../../components/communication/DeleteMsgPop";
import ChatData from "../../../components/communication/ChatData";
import noMsgs from "/public/noMsgs.png";
import UserImage from "../../../components/UserImage";
import UserInfo from "../../../components/UserInfo";
import useChatsStore from "../../../contexts/chats";
import useChatStore from '../../../contexts/chat';
import Loading from "../../../components/Loading";
import OnlineStatusComponent from "../../../components/OnlineStatusComponent";
import {useParams, useLocation} from "react-router-dom";
import PreventBack from "../../../components/PreventBack";
import { Modal } from "rsuite";

export default function Page(){
    const {id} = useParams<{ id: string }>();
    const [chatPageId, setChatPageId] = useState(id.includes('user-') ? null : id);
    const [chat, setChat] = useState<any>({});
    const [messages, setMessages] = useState<any>([]);
    const [visibleInfo, setVisibleInfo] = useState(false);
    const containerRef = useRef<any>(null);
    const msgsLengthRef = useRef<any>(0);
    const lastEl = useRef(null);
    const user = getUserData();
    const [unreadMessages, setUnreadMessages] = useState<any>([]);
    const [replyMsg, setReplyMsg] = useState(null);
    const [socket, setSocket] = useState<any>(null);
    const [deleteMsgPop, setDeleteMsgPop] = useState(null);
    const [chatUser, setChatUser] = useState(null);
    const router = useLocation();
    const query = new URLSearchParams(useLocation().search);
    const type = query.get('type');
    const [usersTyping, setUsersTyping] = useState<any>([]);
    const [drawMessages, setDrawMessages] = useState<any>({});
    const chatsStore = useChatsStore((state:any) => state.chats);
    const [forwardMsg, setForwardMsg] = useState<any>(null);
    const [editMsg, setEditMsg] = useState<any>(null);
    const showChat = useChatStore((state:any) => state.showChat);
    let bubbleCounter = 0;
    const user_token = getToken();
    const uploaderRef = useRef(null);
    const customHeaders = {
        'Authorization': 'Bearer ' + user_token,
    };

    useEffect(() => {
        const uploaderTrigger = uploaderRef.current?.querySelector('.rs-uploader-trigger'); // Adjust class name if needed

        const handleClick = (event) => {
            event.preventDefault();
            event.stopPropagation();
            // Optionally, you could add some visual indication that only drag is allowed
            console.log('Clicking is disabled. Please drag files.');
        };

        if (uploaderTrigger) {
            uploaderTrigger.addEventListener('click', handleClick);
        }

        return () => {
            if (uploaderTrigger) {
                uploaderTrigger.removeEventListener('click', handleClick);
            }
        };
    }, []);

    function drawReceiverMessage({ newMessage, chatId } : { newMessage:any, chatId:any }) {
        if (chatPageId == chatId) {
            setMessages((prevMessages:[]) => [...prevMessages, newMessage]);
            setUnreadMessages((prevMessages:[]) => [...prevMessages, newMessage]);
        }
    }

    function updateMessagesSeen({ msgs, chatId }:{ msgs:[], chatId:any }) {
        if (chatId == chatPageId) {
            setTimeout(() => {
                updateMessageSeenState(msgs);
            }, 1000);
        }
    }

    function updateMessageSeenState(msgs:[]) {
        setMessages((prevMessages:[]) => {
            let arr:any = [];
            prevMessages.map((msg:any) => {
                let updateMessageSeen = msgs.find((item:any) => item._id == msg._id);
                if (updateMessageSeen) {
                    arr.push(updateMessageSeen);
                } else {
                    arr.push(msg);
                }
            });
            return arr;
        });
    }

    useEffect(() => {
        if(socket){
            socket.on('message', (data:any) => {
                if(chatPageId){
                    socket.emit('join-chat-room', { chatId: chatPageId, type });
                }
            });
            socket?.on('new message', drawReceiverMessage);
            socket?.on('message-sent', updateMessagesSeen);
            socket?.on('typing', ({ typing, userId }:{ typing:any, userId:any }) => {
                if (userId != user['id']) {
                    if(typing){
                        if(!usersTyping.includes(userId)){
                            setUsersTyping((prev:any)=> Array.from(new Set([...prev, userId])));
                        }
                    }else{
                        setUsersTyping((prev:any)=>{
                            let arr = prev.filter((usr:any)=>usr != userId);
                            return arr;
                        });
                    }
                }
            });
        }
    }, [socket]);

    useEffect(() => {
        if(chatPageId){
            setSocket(io(SOCKETURL));
            return () => {
                socket?.off("new message", drawReceiverMessage);
                socket?.off("message-sent", updateMessagesSeen);
            };
        }
    }, [chatPageId]);

    useEffect(()=>{
        const userToken = getToken();
        if(chatPageId){
            axios.get(import.meta.env.VITE_BASE_URL + ("get-chat-messages"), {
                params: {id:chatPageId, type},
                headers: {
                    Authorization: "Bearer " + userToken,
                },
                onDownloadProgress:function (progressEvent){
                    // console.log(JSON.parse(progressEvent.event.target.response))
                }
            }).then(res=>{
                if(res.data.status === 'success' && res.data.chat){
                    const msgs = res.data.chat ? res.data.chat.messages.msgs : [],
                        unread = msgs.filter((msg:any) => !msg.seen.includes(user.id) && msg.senderId != user['id']);
                    const cht = res.data.chat;
                    cht.messages = {msgs: [], unseenCount: 0};
                        setChat(cht);
                        setMessages(msgs);
                        setUnreadMessages(unread);
                }
            }).catch((res)=>{
                console.log(res)
            });
        }else{
            axios.get(import.meta.env.VITE_BASE_URL + "get-user-for-chat", {
                params: {user_id:id.split('-')[1]},
                headers: {
                    Authorization: "Bearer " + userToken,
                },
            }).then(res=>{
                const data = res.data;
                if(data.status === 'redirect'){
                    router.replace('/dashboard/chat/' + data.chat_id);
                }else if(data.status == 0){
                    router.replace('/dashboard/communicator')
                }else if(res.data.status === 'success'){
                    setChatUser(res.data.user);
                }
            }).catch((res)=>{
                console.log(res)
            });
        }
    }, []);

    useEffect(() => {
        if (unreadMessages.length) {
            socket?.emit('messages-seen', { unreadMessages, chatId: chatPageId, userId: user.id, type },
                ({ msgs, chatId } : { msgs:any, chatId:any }) => {
                    if (chatId == chatPageId) {
                        setTimeout(() => {
                            setUnreadMessages((prevMessages:[]) => {
                                let arr:[] = [];
                                prevMessages.map((msg:any) => {
                                    let updateMessageSeen = msgs.find((item:any) => item._id == msg._id);
                                    if (!updateMessageSeen) {
                                        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                                        // @ts-expect-error
                                        arr.push(msg);
                                    } else {
                                        let el = document.getElementById(msg._id);
                                        if (el) {
                                            el.classList.remove('unseen-message');
                                        }
                                    }
                                });
                                return arr;
                            });
                        }, 10000);
                    }
                }
            );
        }
    }, [unreadMessages]);

    useEffect(() => {
        const arr:any = {};
        for (let i = 0 ; i< messages.length; i++){
            const date = new Date(typeof messages[i].createdAt == "string"? messages[i].createdAt : messages[i].createdAt ?.$date.$numberLong * 1).toLocaleString('sv-SE',{ year: 'numeric', month: 'numeric', day: 'numeric' });
            if(i == 0){
                arr[date] = [messages[0]];
            }else if(arr[date]){
                arr[date]?.push(messages[i]);
            }else{
                arr[date] = [messages[i]];
            }
        }
        setDrawMessages(arr);
    }, [messages]);

    useEffect(() => {
        if (containerRef.current && lastEl.current && messages.length != msgsLengthRef.current) {
            scrollToElement(lastEl.current);
            msgsLengthRef.current = messages.length
        }
    }, [drawMessages]);

    function scrollToElement(element:any) {
        const targetPosition = element.offsetTop;
        containerRef.current.scrollTo({
            top: targetPosition - 100,
            behavior: 'smooth',
        });
    }

    function sendForwardMsg(chat:any, type=null){
        if(forwardMsg){
            let msgObj = {
                forwarded: 1,
                chatId: chat.id,
                users: chat.users,
                senderId: user.id,
                message: forwardMsg.message,
                messageType: forwardMsg.messageType,
                chat,
                type
            }

            socket?.emit('send-message', msgObj, ({ newMessage, chatId } : { newMessage:any, chatId:any }) => {
                // console.log(newMessage)
            });
            setForwardMsg(null);
        }
    }

    let otherUser:any = (chat && chat.users) ? chat.users.find((usr:any)=>usr.id != user.id || (chat.users.length == 1 && chat.users.find((usr:any)=>usr.id == user.id))) : chatUser;


    const customHeader = (
        <div className={`ryb-chat-head ${styles.chatHead}`}>
            { !!Object.keys(chat).length ?
            <>
                <span data-id={id} id="ryb-chat-id"></span>
                { type === 'team' ?
                    <h5>
                        <UserImage user={chat} type={'team'} width={42} height={42} />
                        <span>
                            {chat.name}
                            {/*<span>Last seen: 12/3/2025</span>*/}
                        </span>
                    </h5>
                    :
                    <>
                        {otherUser &&
                        <h5>
                            <span onClick={()=> setVisibleInfo(prev=>!prev)}>
                                <UserImage type={"user"} user={otherUser} width={42} height={42} />
                            </span>
                            <span className="ryb-chat-head-user-name">
                                {otherUser && otherUser.fullName}
                                <span className="ryb-chat-user-seen"><OnlineStatusComponent user={otherUser}/></span>

                            </span>
                            <UserInfo user={otherUser} socket={socket} chat={chat} setMessages={setMessages} messages={messages} visible={visibleInfo} />
                        </h5>
                        }
                    </>
                }

                {
                ( type === 'team' && chat.users && !!chat.users.length) &&
                    <div className="ryb-chat-head-actions">
                        <div className='ryb-chat-items'>
                            <ul className='flex'>
                                {
                                    chat.users.map((usr:any)=>{
                                        return (
                                            <li key={usr.id + 'upper-user-image'}>
                                                <span className="ryb-chat-team-user-tip">{usr.fullName}</span>
                                                <UserImage type={"user"} user={usr} width={42} height={42} count={0} />
                                            </li>
                                        )
                                    })
                                }
                            </ul>
                        </div>
                    </div>
                }

                <ChatData messages={messages} scrollToElement={scrollToElement} socket={socket} setMessages={setMessages} chat={chat} otherUser={otherUser} />

            </>
            :
            <>
                { chatUser &&
                    <h5>
                        <span onClick={()=> setVisibleInfo(prev=>!prev)}>
                            <UserImage type={"user"} user={otherUser} width={42} height={42} count={0} />
                        </span>
                        <UserInfo user={otherUser} visible={visibleInfo} chat={chat} socket={socket} setMessages={setMessages} messages={messages} />
                        {otherUser && otherUser.fullName}
                    </h5>
                }
            </>
            }
        </div>
    );

    return(
        <PreventBack title={""} headerElement={customHeader} customClass={"ryb-chat-page"}>
            <div className="ryb-live-chat-wrapper">
                <div className={`ryb-chat-messages-wrapper`} ref={containerRef}>
                        {
                            Object.keys(chat).length || chatUser ?
                                <>
                                    {
                                        messages.length ?
                                            <>
                                                <ul className="chat-item-msgs">
                                                    {Object.keys(drawMessages).map((date) => {
                                                        return (
                                                            <li key={date + 'date'}>
                                                                <span className="ryb-msg-day"><b>{formatDate(date, true)}</b></span>
                                                                {drawMessages[date] &&
                                                                    <ul className={`ryb-chat-messages${type === 'team' ? ' ' + bblStyles.teamChatMsgs : ''}`}>
                                                                    {drawMessages[date].map((message: any) => {
                                                                        return (
                                                                            <Bubble
                                                                                type={type}
                                                                                msg={message}
                                                                                bubbleIndex={bubbleCounter++}
                                                                                setEditMsg={setEditMsg}
                                                                                setForwardMsg={setForwardMsg}
                                                                                replyMsg={replyMsg}
                                                                                setReplyMsg={setReplyMsg}
                                                                                setMessages={setMessages}
                                                                                orderChat={chat} messages={messages}
                                                                                socket={socket}
                                                                                scrollToElement={scrollToElement}
                                                                                setDeleteMsgPop={setDeleteMsgPop}
                                                                                key={message._id}
                                                                            />
                                                                        )
                                                                    })}
                                                                    </ul>
                                                                }
                                                            </li>

                                                        )
                                                    })}
                                                </ul>
                                                <div ref={lastEl}/>
                                            </>

                                            :
                                            <div className="ryb-no-results-msg">
                                                <img src={noMsgs} alt=""/>
                                                <h6>There are no messages yet!</h6>
                                                Type one below!
                                            </div>
                                    }
                                </>
                                :
                                <Loading/>
                        }
                </div>

                {(deleteMsgPop && chat) &&
                    <DeleteMsgPop
                        type={type}
                        msg={deleteMsgPop}
                        setDeleteMsgPop={setDeleteMsgPop}
                        socket={socket}
                        updateMessageSeenState={updateMessageSeenState}
                        chat={chat}
                    />
                }
                {!!usersTyping.length && <>
                    {
                        type === 'team' &&
                        <span className="ryb-team-typing-users">
                        {usersTyping.map((usrId:any) => {
                            return (
                                <UserImage width={18} height={18} user={chat.users.find((usr:any) => usr.id == usrId)} key={usrId + '-user'}/>
                            )
                        })}
                    </span>
                    }
                    <div className={styles.typing}><span></span><span></span><span></span></div>
                </>
                }
                { forwardMsg &&
                    <Modal open={forwardMsg} onClose={()=>{setForwardMsg(false)}} size={"sm"}>
                        <div className="ryb-forward-msg-pop">
                            <ul>
                                { chatsStore.map((chat:any) => {
                                    const otherUsr = chat.users.find((usr:any)=> usr.id != chat.pivot.user_id);
                                    if(otherUsr && otherUsr.id != otherUser.id){
                                        return(
                                            <li key={'chat-item' + chat.id}>
                                                <UserImage user={otherUsr} type={"user"} width={25} height={25} count={0} />
                                                <span className="ryb-chat-item-content">
                                                    <span className="ryb-chat-item-user-name">{otherUsr.fullName}</span>
                                                </span>
                                                <button onClick={()=>sendForwardMsg(chat)}>send</button>
                                            </li>
                                        )
                                    }
                                })}
                            </ul>
                        </div>
                    </Modal>
                }
                <ChatForm
                    socket={socket}
                    editMsg={editMsg}
                    setEditMsg={setEditMsg}
                    chatUser={chatUser}
                    type={type}
                    setMessages={setMessages}
                    setChatPageId={setChatPageId}
                    orderChat={chat}
                    setOrderChat={setChat}
                    replyMsg={replyMsg}
                    setReplyMsg={setReplyMsg}
                    updateMessageSeenState={updateMessageSeenState}
                />
            </div>
        </PreventBack>
    )
}